<?php

namespace IZON\Thumber\ImageConverter;

use Intervention\Image\ImageManager;
use IZON\IO\Image;
use Intervention\Image\Image as InterventionImage;

/**
 * Description of ImageCoverterFactory
 *
 * @author lukas
 */
class ImagineImageCoverterFactory implements IImageConverterFactory {
    /**
     *
     * @var ImageManager
     */
    protected $imagine;
    /**
     *
     * @var string
     */
    protected $tmpDir;

    /**
     * 
     * @param string $tmpDir
     * @param string $driver default 'gd' also supports 'imagemagick' 
     */
    function __construct(string $tmpDir, string $driver = 'gd') {
        $this->imagine = new ImageManager(['driver' => $driver]);
        $this->tmpDir = $tmpDir;
    }

    /**
     * 
     * @param Image $image
     * @return IImageConverter
     */
    public function createImageConverter(Image $image): IImageConverter {
        $iimage = $this->imagine->make($image->getFsPath());
        $this->fixImageOrientation(($image->getFsPath()), $iimage);
        return new ImagineImageConverter($iimage, $this->tmpDir);
    }

    protected function fixImageOrientation(string $inputImagePath, InterventionImage $image) {
        $exif = exif_read_data($inputImagePath);
        if(!empty($exif['Orientation'])) {
            switch ($exif['Orientation']) {
                case 3:
                    $image->rotate(180);
                    break;
                case 6:
                    $image->rotate(-90);
                    break;
                case 8:
                    $image->rotate(90);
                    break;
            }
        }
    }
}
