<?php

namespace IZON\Thumber\Services;

use IZON\IO\Image;

/**
 * servis pro vytvareni nahledu
 */
interface ThumbnailService {
  /**
   * Default image quality
   */
  const QUALITY = 90;


  /**
     * vrati informace o thumbnailech ze kterych je mozno zjistit 
     * @var GalleryInfo
     */
    public function getThumber();
    
    /**
     * 
     * @param Image $sourceImage
     * @param array $parameters parametry pro resizovani width nebo heigth
     */
    public function getImageURL(Image $sourceImage, array $parameters = []);
    /**
     * 
     * @param string|null $format
     */
    public function setFormat(?string $format);
}
