<?php

namespace IZON\Thumber\ImageResizer\Strategies;

use IZON\Thumber\Image\IImageSize;
use IZON\Thumber\Image\ImageSize;
use IZON\Thumber\ImageResizer\IImageResizerStrategy;

/**
 * CoverImageResizerStrategy computes cover size of image
 *
 * @author lukas
 */
class CoverImageResizerStrategy implements IImageResizerStrategy {

    public static function getSize(IImageSize $imageSize, IImageSize $containerSize): IImageSize {
        if($imageSize->getWidth() < $containerSize->getWidth() || $imageSize->getHeight() < $containerSize->getHeight()) {
            return $imageSize;
        }

        if($containerSize->getAspectRatio() > $imageSize->getAspectRatio()) {
            $height = $containerSize->getHeight();
            $width = floor($height / $imageSize->getAspectRatio());
        } else {
            $width = $containerSize->getWidth();
            $height = floor($width * $imageSize->getAspectRatio());
        }
        return ImageSize::create($width, $height);
    }

}
