<?php

namespace IZON\Thumber\ImageResizer;

use IZON\Thumber\Exceptions\UnsupportedResizeTypeException;

/**
 * Provides image size calculations.
 *
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
interface IImageResizer {
    /**
     * 
     */
    const CONTAIN = 'contain';
    /**
     * 
     */
    const COVER = 'cover';
    /**
     * 
     */
    const SUPPORTED_TYPES = [
        self::CONTAIN,
        self::COVER,
    ];

    /**
     * 
     * @param string $type
     * @throws UnsupportedResizeTypeException
     * @return IImageResizerStrategy
     */
    public function resize(string $type): IImageResizerStrategy;
    /**
     * 
     * @param string $type
     * @param IImageResizerStrategy $strategy
     * @throws UnsupportedResizeTypeException
     * @return IImageResizer 
     */
    public function addStrategy(string $type, IImageResizerStrategy $strategy) : IImageResizer;
}
