<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace IZON\Thumber\Image;

use IZON\Thumber\Services\ThumbnailService;

/**
 * Description of ImageNameBuilder
 *
 * @author lukas
 */
class ImageNameBuilder implements IImageNameBuilder {
    /**
     *
     * @var string
     */
    protected $name;
    /**
     *
     * @var string
     */
    protected $format;
    /**
     *
     * @var string
     */
    protected $path;
    /**
     *
     * @var IImageSize
     */
    protected $size;
    /**
     *
     * @var int|null
     */
    protected $quality;

    /**
     * 
     * @param string $name
     * @param string $format
     * @param string $path
     */
    public function __construct(string $name, string $path, string $format) {
        $this->name = $name;
        $this->path = $path;
        $this->format = $format;
    }

    /**
     * 
     * @return string
     */
    public function build(): string {
        $pathParts = explode('/',\IZON\File\normalizePath($this->path));
        $filename = implode('_', $pathParts);
        $filename .= '_'.$this->name;
        if(!empty($this->size)) {
            $filename .= '_' . $this->size->getWidth() . 'x' . $this->size->getHeight();
        }
        if(!is_null($this->quality) && $this->quality != ThumbnailService::QUALITY) {
            $filename .= '-q' . $this->quality;
        }
        $filename .= '.' . $this->format;
        return $filename;
    }

    /**
     * 
     * @param string $format
     * @return IImageNameBuilder
     */
    public function setFormat(string $format): IImageNameBuilder {
        $this->format = $format;
        return $this;
    }

    /**
     * 
     * @param int $quality
     * @return IImageNameBuilder
     */
    public function setQuality(int $quality): IImageNameBuilder {
        $this->quality = $quality;
        return $this;
    }

    /**
     * 
     * @param IImageSize $size
     * @return IImageNameBuilder
     */
    public function setSize(IImageSize $size): IImageNameBuilder {
        $this->size = $size;
        return $this;
    }

}
