<?php

namespace IZON\Thumber\Image;

/**
 *
 * @author lukas
 */
interface IImageNameBuilder {

    /**
     * 
     * @param string $name
     * @param string $path
     * @param string $format
     */
    public function __construct(string $name, string $path, string $format);

    /**
     * 
     * @param IImageSize $size
     */
    public function setSize(IImageSize $size): IImageNameBuilder;

    /**
     * 
     * @param int $quality
     */
    public function setQuality(int $quality): IImageNameBuilder;

    /**
     * 
     * @param string $quality
     */
    public function setFormat(string $quality): IImageNameBuilder;
    /**
     * return builded name of file
     * @return string
     */
    public function build(): string;
}
