<?php

namespace IZON\Thumber\ImageResizer\Strategies;

use IZON\Thumber\Image\IImageSize;
use IZON\Thumber\Image\ImageSize;
use IZON\Thumber\ImageResizer\IImageResizerStrategy;

/**
 * ContainImageResizerStrategy computes contain image size
 *
 * @author lukas
 */
class ContainImageResizerStrategy implements IImageResizerStrategy {

    public static function getSize(IImageSize $imageSize, IImageSize $containerSize): IImageSize {
        if($imageSize->getAspectRatio() > $containerSize->getAspectRatio()) {
            $height = $containerSize->getHeight();
            $width = floor($height / $imageSize->getAspectRatio());
        } else {
            $width = $containerSize->getWidth();
            $height = floor($width * $imageSize->getAspectRatio());
        }
        if($width > $imageSize->getWidth() || $height > $imageSize->getHeight()) {
            return $imageSize;
        }
        return ImageSize::create($width, $height);
    }

}
