<?php

namespace IZON\Thumber\ImageResizer;

use IZON\Thumber\Exceptions\UnsupportedResizeType;

/**
 * Provides image size calculations.
 *
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
interface IImageResizer {
    /**
     * 
     */
    const CONTAIN = 'contain';
    /**
     * 
     */
    const COVER = 'cover';
    /**
     * 
     */
    const SUPPORTED_TYPES = [
        self::CONTAIN,
        self::COVER,
    ];

    /**
     * 
     * @param string $type
     * @throws UnsupportedResizeType
     * @return IImageResizerStrategy
     */
    public function resize(string $type): IImageResizerStrategy;
    /**
     * 
     * @param string $type
     * @param IImageResizerStrategy $strategy
     * @throws UnsupportedResizeType
     * @return IImageResizer 
     */
    public function addStrategy(string $type, IImageResizerStrategy $strategy) : IImageResizer;
}
