<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace IZON\Thumber\ImageConverter;

use Intervention\Image\Image as InterventionImage;
use IZON\Thumber\Services\ThumbnailService;
use IZON\IO\Image;
use IZON\Thumber\Image\IImageSize;

/**
 * Description of ImagineImageConverter
 *
 * @author lukas
 */
class ImagineImageConverter implements IImageConverter {
    /**
     *
     * @var InterventionImage
     */
    protected $image;
    /**
     *
     * @var string
     */
    protected $tmpDir;
    /**
     *
     * @var int
     */
    protected $quality;
    /**
     *
     * @var string
     */
    protected $format;

    /**
     * 
     * @param InterventionImage $image
     * @param type $tmpDir
     */
    function __construct(InterventionImage $image, $tmpDir) {
        $this->image = $image;
        $this->tmpDir = $tmpDir;
        $this->quality = ThumbnailService::QUALITY;
    }

    public function convert(string $fileName): Image {
        $pathInfo = pathinfo($fileName);
        $newFileName = $this->tmpDir . (mb_substr($this->tmpDir, -1) != '/' ? '/' : '') . $fileName;
        $this->image->save($newFileName, $this->quality);
        return new Image($newFileName);
    }

    /**
     * is dummy for this implementation
     * @param string $format
     * @return IImageConverter
     */
    public function setFormat(string $format): IImageConverter {
        $this->format = $format;
        return $this;
    }

    /**
     * 
     * @param int $quality
     * @return IImageConverter
     */
    public function setQuality(int $quality): IImageConverter {
        $this->quality = $quality;
        return $this;
    }

    /**
     * 
     * @param IImageSize $imageSize
     * @return IImageConverter
     */
    public function setSize(IImageSize $imageSize): IImageConverter {
        $this->image->resize($imageSize->getWidth(), $imageSize->getHeight());
        return $this;
    }

}
