<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace IZON\Thumber\Image;

use IZON\Thumber\Image\Exceptions\InvalidSizeException;

/**
 * Description of ImageSize
 *
 * @author lukas
 */
class ImageSize implements IImageSize {
    protected $width;
    protected $height;

    protected function __construct() {
        
    }

    public function getAspectRatio(): float {
        return $this->height / $this->width;
    }

    public function getHeight(): int {
        return $this->height;
    }

    public function getWidth(): int {
        return $this->width;
    }

    public static function create(int $width, int $height): ImageSize {
        $size = new static();

        if($width <= 0 && $height <= 0) {
            throw new InvalidSizeException('Width and height must be greater then zero.');
        }
        if($width <= 0) {
            throw new InvalidSizeException('Width must be greater then zero.');
        }
        if($height <= 0) {
            throw new InvalidSizeException('Width must be greater then zero.');
        }
        $size->width = $width;
        $size->height = $height;
        return $size;
    }

    public static function createFromWidth(int $width, float $aspectRatio): ImageSize {
        $size = new static();
        $size->width = $width;
        $size->height = $aspectRatio * $width;
        return $size;
    }

    public static function createFromHeight(int $height, float $aspectRatio): ImageSize {
        $size = new static();
        $size->height = $height;
        $size->width = $height / $aspectRatio;
        return $size;
    }

}
