<?php

namespace IZON\Thumber\Web\Interceptors;

use \IZON\Logs\Logger;

use \IZON\MVC\Interceptors\Interceptor;
use \IZON\MVC\HttpRequest;
use \IZON\MVC\ModelAndView;

use IZON\Thumber\Services\ThumbnailService;

/**
 * nacita informace o ga
 */
class ThumberInterceptor implements Interceptor {
    
    /**
     *
     * @var ThumbnailService 
     */
    protected $thumberService;
    
    /**
     * logger pro tridu
     * @var Logger 
     */
    protected $log;
    
    
    public function __construct(ThumbnailService $thumberService) {
        $this->thumberService = $thumberService;
        
        // logovani
        $this->log = Logger::getLogger(__CLASS__);
    }
    
    public function afterCompletion(HttpRequest $request, $exception) {
        
    }

    public function preHandle(HttpRequest $request) {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model) {
        // adds information about gallery
        $model->putParameter(\IZON\Thumber\Thumber::AVAILABLE_AS, $this->thumberService->getThumber());
        return $model;
    }

}
