<?php

namespace IZON\Thumber;

use IZON\Thumber\Services\ThumbnailService;

use IZON\IO\Image;

/**
 * Slouzi k vygenerovani a vraceni nahledu obrazku
 */
class Thumber {
  /**
   * @deprecated
   */
  const VIEW_NAME = '_thumber';
  const AVAILABLE_AS = '_thumber';

  /**
     *
     * @var ThumbnailService
     */
    protected $thumberService;
    
    function __construct($thumberService) {
        $this->thumberService = $thumberService;
    }

    /**
     * vraci url na ktrem se da stahnout resizovany obrazek
     * @param [Image|path_to_image] $sourceImage zdrojovy obrazek nebo cesta k nemu
     * @param array $parameters parametry pro resizovani <br>width = cislo, <br>heigth = cislo, <br>type type = ["contain": vleze se do, "cover": da se pokryt] default je contain, <br>quality = number, default = 90 <br>napr. ["width" => 1234], ["width" => 1234, "type" => "contain"]
     * @return string
     */
    public function getImageURL($sourceImage, array $parameters = []) {
      if(!$sourceImage instanceof Image) {
        $sourceImage = $this->getImageObject($sourceImage);
      }
      return $this->thumberService->getImageURL($sourceImage, $parameters);
    }
    /**
     * Returns Image object for src
     * 
     * @param string $src relative path to file with first /
     * @return Image
     * @throws \Exception
     */
    public function getImageObject($src) {
      $imagePath = __BASE_DIR__.'/www'. $src;
      if(!file_exists($imagePath) || !is_file($imagePath) ) {
        throw new \Exception(__METHOD__.':: File not found:: '.$src);
      } 
      $img = new Image($imagePath);
      return $img;
    }
}
