<?php

namespace IZON\Thumber\Services\Impl;

use \Exception;

use \IZON\IO\Image;

use \IZON\Gallery\ImageResizer;

use IZON\Thumber\Services\ThumbnailService;
use IZON\Thumber\Thumber;

/**
 * servis pro zpracovani obrazku, mozna i dalsiho multimedialniho obsahu z galerie
 */
class ThumbnailServiceImpl implements ThumbnailService {
    
    /**
     *
     * @var string do jakeho adresare se budou ukladat nahledy
     */
    protected $thumbDir;
    
    public function __construct($thumbDir) {
        $this->thumbDir = $thumbDir;
    }
    
    
    public function getThumber() {
      return new Thumber($this);
    }


    /**
     * 
     * @param Image $sourceImage
     * @param array $parameters parametry pro resizovani
     */
    public function getImageURL(Image $sourceImage, array $parameters = []) {
        // test jestli je z podporovanych adresaru
        $sourceDir = $sourceImage->getDir();
        
        $parameters['width'] += 0;
        $parameters['height'] += 0;

        $original_size = getimagesize($sourceImage->getFsPath());
        
        $thumb['w'] = 0;
        $thumb['h'] = 0;
        if( isset($parameters["type"]) && $parameters["type"] == "cover" ) { 
            list($thumb['w'], $thumb['h']) = ImageResizer::getNewCoverImageSize(array($original_size[0], $original_size[1]), 
                                                                            array($parameters['width'], $parameters['height']));
        } else {
            list($thumb['w'], $thumb['h']) = ImageResizer::getNewImageSize(array($original_size[0], $original_size[1]), 
                                                                        array($parameters['width'], $parameters['height']));
        }
        
        $pathParts = pathinfo($sourceImage->getFsPath());
        $thumbName = $pathParts['filename'] ."_". $thumb['w']. 'x' . $thumb['h'] .".". $sourceImage->getExtension();
        
        $resizerParams['sourceFile']          = $sourceImage->getFileName();
        $resizerParams['sourceDir']           = $sourceImage->getDir() .'/';
        $resizerParams['newSize']             = array($thumb['w'], $thumb['h']);
        $resizerParams['targetDir']           = $this->thumbDir.'/';
        $resizerParams['targetFile']          = $thumbName;
        $resizerParams['params']['quality']   = array_key_exists('quality', $parameters) ? $parameters['quality'] : self::QUALITY ;
        
        try {
          if (file_exists($resizerParams['targetDir'] . $thumbName) && is_file($resizerParams['targetDir'] . $thumbName)) {
            // pokud jiz nahled v pozadovane velikosti existuje
            if (filemtime($sourceImage->getFsPath()) > filemtime($resizerParams['targetDir'] . $thumbName)) {
              // je nahled starsi, nez zdrojovy obrazek - vygenerujem novy nahled
              ImageResizer::resizerParams($resizerParams);
            }
          } else {
            // nahled neni, vygenerujem jej
            ImageResizer::resizerParams($resizerParams);
          } 
        } catch (Exception $exc) {
          throw $exc;
        }
        
        return $this->thumbDir .'/'. $thumbName.'?'.filemtime($resizerParams['targetDir'] . $thumbName);
    }
}
