<?php

namespace IZON\MVC\Routers;

use \PDO;

use \IZON\Logs\Logger;

use IZON\MVC\HttpRequest;
use IZON\MVC\PageInfo;

use IZON\MVC\Interceptors\PageInfoInterceptor;

/**
 * Definice routovani nacitana z db
 */
class GalleryRouteDefinition implements RouteDefinition {
    
    /**
     * v jakem adresari je gallerie ulozena
     * @var string  
     */
    protected $galleryDir = "";

    /**
     *
     * @var array z jakych adresaru je mozne delat resizovani galerie 
     */
    protected $sourceDirs;

    /**
     *
     * @var Logger 
     */
    protected $log = NULL;
    
    
    public function __construct($galleryDir,
                                array $sourceDirs) {
        $this->galleryDir = $galleryDir;
        $this->sourceDirs = $sourceDirs;
        
        $this->log = Logger::getLogger(self::class);
    }
    
    public function findRoute(HttpRequest $request) {
        
        return NULL;
    }

    public function findURL($controllerId, array $parameters, $lang) {
        $this->log->info("searching for url for controolerId = $controllerId with ". count($parameters) ." parameters");
    }

    
    function setInterceptors($interceptors) {
        $this->interceptors = $interceptors;
    }
}
