<?php


namespace IZON\Templating;

interface TemplateFactoryInterface
{
    /**
     * test if factory has template with $templateName
     * if test not available has returns true
     * @param string $templateName
     * @return bool
     */
    public function has(string $templateName): bool;

    /**
     * @param string $templateName
     * @param array<string, mixed> $params
     * @return TemplateInterface
     */
    public function create(string $templateName, array $params = []): TemplateInterface;
}
