<?php


namespace IZON\Templating;

/**
 * @deprecated use ViewDataStream instead
 */
class TemplateStream implements TemplateStreamInterface
{
    /**
     * @var string
     */
    protected string $name;

    /**
     * @var array<string, mixed>
     */
    protected array $parameters = [];

    /**
     * @param string $name
     * @param array<string, mixed> $parameters
     */
    public function __construct(string $name, array $parameters = [])
    {
        $this->name = $name;
        $this->parameters = $parameters;
    }


    public function __toString(): string
    {
        return '';
    }

    /**
     * {@inheritDoc}
     * @return void
     */
    public function close(): void
    {
        // DO NOTHING
    }

    /**
     * @return resource|null
     */
    public function detach()
    {
        return null;
    }

    /**
     * {@inheritDoc}
     * @return int|null
     */
    public function getSize(): ?int
    {
        return 0;
    }

    /**
     * {@inheritDoc}
     * @return int
     */
    public function tell(): int
    {
        return 0;
    }

    /**
     * {@inheritDoc}
     * @return bool
     */
    public function eof(): bool
    {
        return true;
    }

    /**
     * {@inheritDoc}
     * @return bool
     */
    public function isSeekable(): bool
    {
        return false;
    }

    /**
     * {@inheritDoc}
     * @param int $offset
     * @param int $whence
     * @return void
     */
    public function seek($offset, $whence = SEEK_SET): void
    {
        throw new \RuntimeException('Template stream is not seekable');
    }

    /**
     * {@inheritDoc}
     * @return void
     */
    public function rewind(): void
    {
        throw new \RuntimeException('Template stream is not seekable');
    }

    public function isWritable(): bool
    {
        return false;
    }

    /**
     * {@inheritDoc}
     * @param string $string
     * @return int
     */
    public function write($string): int
    {
        throw new \RuntimeException('Template stream is not writable');
    }

    /**
     * {@inheritDoc}
     * @return bool
     */
    public function isReadable(): bool
    {
        return false;
    }

    /**
     * {@inheritDoc}
     * @param int $length
     * @return string
     */
    public function read($length): string
    {
        throw new \RuntimeException('Template stream is not readable');
    }

    /**
     * {@inheritDoc}
     * @return string
     */
    public function getContents(): string
    {
        throw new \RuntimeException('Template stream is not writable');
    }

    public function getMetadata($key = null)
    {
        if ($key === null) {
            return [];
        }
        return null;
    }

    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return array<string, mixed>
     */
    public function getParameters(): array
    {
        return $this->parameters;
    }

    public function hasParameter(string $name): bool
    {
        return array_key_exists($name, $this->parameters);
    }

    /**
     * @param string $name
     * @return null|mixed
     */
    public function getParameter(string $name)
    {
        if (array_key_exists($name, $this->parameters)) {
            return $this->parameters[$name];
        }
        return null;
    }

    /**
     * @param string $name
     * @param null|mixed $value
     * @return void
     */
    public function putParameter(string $name, $value): void
    {
        $this->parameters[$name] = $value;
    }
}
