<?php


namespace IZON\Templating;


class TemplateStream implements TemplateStreamInterface {
    /**
     * @var string
     */
    protected $name;
    /**
     * @var array
     */
    protected $parameters = [];

    /**
     * TemplateStream constructor.
     * @param string $name
     * @param array $parameters
     */
    public function __construct(string $name, array $parameters = []) {
        $this->name = $name;
        $this->parameters = $parameters;
    }


    public function __toString() {
        return '';
    }

    public function close() {
        // DO NOTHING
    }

    public function detach() {
        return null;
    }

    public function getSize() {
        return 0;
    }

    public function tell() {
        return 0;
    }

    public function eof() {
        return true;
    }

    public function isSeekable() {
        return false;
    }

    public function seek($offset, $whence = SEEK_SET) {
        throw new \RuntimeException('Template stream is not seekable');
    }

    public function rewind() {
        throw new \RuntimeException('Template stream is not seekable');
    }

    public function isWritable() {
        return false;
    }

    public function write($string) {
        throw new \RuntimeException('Template stream is not writable');
    }

    public function isReadable() {
        return false;
    }

    public function read($length) {
        throw new \RuntimeException('Template stream is not readable');
    }

    public function getContents() {
        throw new \RuntimeException('Template stream is not writable');
    }

    public function getMetadata($key = null) {
        if($key === null) {
            return [];
        }
        return null;
    }

    public function getName(): string {
        return $this->name;
    }

    public function getParameters(): array {
        return $this->parameters;
    }

    public function hasParameter(string $name): bool {
        return array_key_exists($name, $this->parameters);
    }

    public function getParameter(string $name) {
        if(array_key_exists($name, $this->parameters)) {
            return $this->parameters[$name];
        }
        return null;
    }

    public function putParameter(string $name, $value): void {
        $this->parameters[$name] = $value;
    }

}
