<?php
namespace IZON\Templating;

interface TemplateSeedInterface {
    /**
     * @return string
     */
    public function getName(): string;

    /**
     * @return array
     */
    public function getParameters(): array;

    /**
     * @param string $name
     * @return bool
     */
    public function hasParameter(string $name): bool;

    /**
     * @param string $name
     * @return mixed
     */
    public function getParameter(string $name);

    /**
     * @param string $name
     * @param $value
     */
    public function putParameter(string $name, $value) : void;
}
