<?php

namespace IZON\Templating\Latte\Loaders;

use Latte\Loaders\FileLoader as LatteFileLoader;

class FileLoader extends LatteFileLoader
{
    public function getReferredName(string $file, string $referringFile): string
    {
        if (str_starts_with($file, '//') && $this->baseDir) {
            $file = substr($file, 2);
            return $this->normalizePath($file);
        }

        return parent::getReferredName($file, $referringFile);
    }
}
