<?php

namespace IZON\Templating\Latte;

use IZON\Templating\TemplateFactoryInterface;
use IZON\Templating\TemplateInterface;
use Latte\Engine;

class LatteTemplateFactory implements TemplateFactoryInterface
{
    protected Engine $engine;

    /**
     * @var string prefix to append to view name to create tmaplate name
     */
    protected string $templatePrefix = '';

    /**
     * @var string suffix to append to view name to create tmaplate name
     */
    protected string $templateSuffix = '';


    public function __construct(Engine $engine)
    {
        $this->engine = $engine;
    }


    public function has(string $templateName): bool
    {
        // DOTO: better template existence checking
        return true;
    }

    /**
     * @param string $templateName
     * @param array<string, mixed> $params
     * @return TemplateInterface
     */
    public function create(string $templateName, array $params = []): TemplateInterface
    {
        $templateName = $this->getExpandedTemplateName($templateName);
        return new LatteTemplate($this->engine, $templateName, $params);
    }

    /**
     * @param string $templatePrefix
     */
    public function setTemplatePrefix(string $templatePrefix): void
    {
        $this->templatePrefix = $templatePrefix;
    }

    /**
     * @param string $templateSuffix suffix to append to view name to create tmaplate name
     */
    public function setTemplateSuffix(string $templateSuffix): void
    {
        $this->templateSuffix = $templateSuffix;
    }

    protected function getExpandedTemplateName(string $tempateName): string
    {
        return $this->templatePrefix . $tempateName . $this->templateSuffix;
    }
}
