<?php


namespace IZON\Templating\Latte;

use IZON\Templating\TemplateInterface;
use Latte\Engine;

class LatteTemplate implements TemplateInterface
{
    protected Engine $engine;

    /**
     * @var string name of template to render. Path to file in Latte
     */
    protected string $name;

    /**
     * @var array<string, mixed> parameters user for template rendering
     */
    protected array $parameters = [];

    /**
     * LatteTemplate constructor.
     * @param Engine $engine
     * @param string $name Name of template to render. Path to file in Latte,
     * @param array<string, mixed> $parameters parameters user for template rendering
     */
    public function __construct(Engine $engine, string $name, array $parameters = [])
    {
        $this->engine = $engine;
        $this->name = $name;
        $this->parameters = $parameters;
    }


    public function render(): string
    {
        return $this->engine->renderToString($this->name, $this->parameters);
    }

    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return array<string, mixed> parameters user for template rendering
     */
    public function getParameters(): array
    {
        return $this->parameters;
    }

    public function hasParameter(string $name): bool
    {
        return array_key_exists($name, $this->parameters);
    }

    public function getParameter(string $name): mixed
    {
        if (array_key_exists($name, $this->parameters)) {
            return $this->parameters[$name];
        }
        return null;
    }

    public function putParameter(string $name, mixed $value): void
    {
        $this->parameters[$name] = $value;
    }
}
