<?php

namespace IZON\Templating\Latte;

use Latte\Engine;
use Latte\Runtime\Template;
use Psr\Log\LoggerInterface;

class LatteEngine extends Engine
{
    /**
     * @var LoggerInterface|null logger to log created templates to
     */
    protected ?LoggerInterface $createdTemplatesLogger = null;

    public function createTemplate(string $name, array $params = [], $clearCache = true): Template // @phpstan-ignore missingType.parameter
    {
        if ($this->createdTemplatesLogger !== null) {
            $this->createdTemplatesLogger->info(
                'Creating template ' . $name,
                [
                    'templateName' => $name,
                    'templateParameters' => $params
                ]
            );
        }

        return parent::createTemplate($name, $params);
    }

    /**
     * @param LoggerInterface $createdTemplatesLogger logger to log created templates to
     */
    public function setCreatedTemplatesLogger(LoggerInterface $createdTemplatesLogger): void
    {
        $this->createdTemplatesLogger = $createdTemplatesLogger;
    }
}
