<?php

namespace IZON\Templating\Latte\Loaders;

use IZON\Utils\Locale;
use IZON\Utils\StringUtils;
use Latte\Loaders\FileLoader as LatteFileLoader;

class FileLoader extends LatteFileLoader
{
    protected ?Locale $locale = null;

    public function getReferredName($file, $referringFile): string
    {
        if (StringUtils::startsWith($file, '//')) {
            $file = substr($file, 2);
            $referringFile = '';
        }

        if ($this->locale !== null) {
            $localizedFile = preg_replace(
                '#.latte$#',
                '.' . $this->locale->toLocaleTag() . '.latte',
                $file
            );
            if (file_exists($this->baseDir . "/" . $localizedFile)) { // does
                return $localizedFile;
            }
        }

        return parent::getReferredName($file, $referringFile); // TODO: Change the autogenerated stub
    }

    /**
     * @param null|Locale $locale
     */
    public function setLocale(?Locale $locale): void
    {
        $this->locale = $locale;
    }

    public function hasTemplate(string $templateName): bool
    {
        $file = $this->baseDir . $templateName;
        return file_exists($file);
    }
}
