<?php

namespace IZON\Templating\Latte;

use IZON\MVC\Context\Context;
use IZON\Templating\Latte\Loaders\FileLoader;
use IZON\Templating\TemplateFactoryInterface;
use IZON\Templating\TemplateInterface;
use IZON\Templating\TemplateSeedInterface;
use Latte\Engine;
use Latte\RuntimeException;

class LatteTemplateFactory implements TemplateFactoryInterface
{
    protected Engine $engine;

    public function __construct(Engine $engine)
    {
        $this->engine = $engine;
    }

    public function has(string $templateName): bool
    {
        $loader = $this->engine->getLoader();
        if($loader instanceof FileLoader) {
            return $loader->hasTemplate($templateName);
        }
        try {
            $loader->getContent($templateName);
        } catch(RuntimeException $exception) {
            return false;
        }
        return true;
    }

    /**
     * @param string $templateName
     * @param array<string, mixed> $params
     * @return TemplateInterface
     */
    public function create(string $templateName, array $params = []): TemplateInterface
    {
        $loader = $this->engine->getLoader();
        if ($loader instanceof FileLoader) {
            if (
                array_key_exists('_context', $params)
                && $params['_context'] instanceof Context
            ) {
                $context = $params['_context'];
                $loader ->setLocale($context->getLocale());
            } else {
                $loader->setLocale(null);
            }
        }
        $templateName = $this->engine->getLoader()
            ->getReferredName($templateName, '');
        return new LatteTemplate($this->engine, $templateName, $params);
    }

    /**
     * @param TemplateSeedInterface $seed
     * @return TemplateInterface
     * @deprecated use create() instead
     */
    public function grow(TemplateSeedInterface $seed): TemplateInterface
    {
        return $this->create($seed->getName(), $seed->getParameters());
    }
}
