<?php


namespace IZON\Templating\Latte;

use IZON\Templating\Latte\TracyBar\LatteTracyBar;
use Latte\Engine;
use Latte\Runtime\Template;

class LatteEngine extends Engine
{
    /** @var LatteTracyBar|null */
    protected $latteTracyBar = null;

    public function createTemplate(string $name, array $params = []): Template
    {
        if (!is_null($this->latteTracyBar)) {
            $this->latteTracyBar->addTemplate($name, $params);
        }

        return parent::createTemplate($name, $params);
    }

    public function setLatteTracyBar(?LatteTracyBar $latteTracyBar): void
    {
        $this->latteTracyBar = $latteTracyBar;
    }
}
