<?php


namespace IZON\Templating\Latte\TracyBar;

use Nette\Utils\Html;
use Nette\Utils\Strings;
use Tracy\Debugger;
use Tracy\Dumper;
use Tracy\Helpers;
use Tracy\IBarPanel;

class LatteHelperTracyBar implements IBarPanel {

    /** @var string */
    private static $data = [
        'functions' => [],
        'macros' => [],
        'filters' => [],
    ];

//    /** @var int */
//    private $count = 0;

    function addFilter(string $name, string $description): void {
        self::$data['filters'][Strings::webalize($name)] = [
            'name' => $name,
            'description' => $description,
        ];
    }

    function addFunction(string $name, string $description): void {
        self::$data['functions'][Strings::webalize($name)] = [
            'name' => $name,
            'description' => $description,
        ];
    }

    function addMacro(string $name, string $description): void {
        self::$data['macros'][Strings::webalize($name)] = [
            'name' => $name,
            'description' => $description,
        ];
    }

    function getTab() {
        //$imgBase64 = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABcAAAAXCAIAAABvSEP3AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAAB3RJTUUH5AYZACwTXt808QAABH1JREFUOMttlctv1FUUx7/n3vt7zG+e7fQ1BcsrpQXBgMZIjDHakKhsWOOOGOKTFRsTY4z/gAkJS4kbFxITjSS+gqxYKESpIoiSppRHTVvb6cy0M7/5/X73nuNiClrjXZ57vueenHvO59DExDgAAEQACICI4F9HEXiTAUQEbHI0D++sk55Zqw23Xtg4k9AQCD2NCKzj3qta0aYoLFKOvHygtaaVVtrN2GiyTjIrkzV/ZjFjkdBT1kngqYGS75x0UtfsZIoIgB4crDqWHUPRxJbCYCkYKgcra2kndesJB4Ye3RKcPjZ0ezmrt3m14xShr+DtHyv1F/zhSqCI6uuZVkS7d48bTU/sKntaLTaSpWYSp64Zu2OHSsefKY2WDQFEaMb81a/tD75dJVAxpwdKwUglsE6uzjZSK0YATxOBBPhztdvqZHGG16Yq7x6tOiuplW4qoUeDRX1iqlKJ9KlP/kqty5wMlwMiGK0SaxWAjUoLPE2WafeIf3KqkiY8fad7/OzC3Xr2xsdLP84l7XV3ZH/+wFiQWhhND0TS+0ewgEWIYBTFKT+1MyyGighnLjYu3Yo9Td/PxGcvNfMFnS+oJ3eG3UyMIiKwgBkAGSKIiAiIoBSJIAqUAAQarRjHsE6GS3r6TnLiwwUC5lZsFGy0Vk+oCCa1HHrGPCiN1phdyjSh2eWTh/sCj5SixMrccrbYslqR0fA0CdDL3WhqJ6z37KxtG4pyvm527L3l2Dd0ezmbqAX7tgWK5bnJqBCog2NhOdILTRenkg+UCFIrxZzJ+TofaID0swe29+W9Rsf+Pr+WWDaKROjib+3QqPFhP+cp62Ss3xzeG730WH5pzV2/n+Z8lTlutLNizlSLfiE0OipVlKK+yCtFXn09cwzfkAgu3Gh/c709v2r3bQ2IyLHkfXX08cJPc8mthbQQ6j1bi5XIq69nd5ZjHUTldmKHK0EUmFactRPXSaWTilLU7PC1e8mL+/PvfL4yVjW1sumN2Pnp9dH+4JFqaFluzq/V1zLjGXIs1onRQkSplVefr0zW/LUun/mu4VhCQzfuJ+9/Uf/srRoLqgXtG+oNrmNxDN8oIwIiUgQRiEhi5eD28MjBAli+/KX9w0xMREZTJ2XHUETdTBwLM0SgiBTAAiWAIhCRCFhEgMszMSfcXHNvTlUma37mpFbWp17o8xRpjSuzXRYINlqMFAAxGxwBQMichIbOT6+/fKg0MeI9vSs89/qoY/nolZFyTvm+ujrXPXelFXqUWXkgIgB6oFoFUOsPtCICaUXNjrt4szNYNNWCrkSKCMVQt2L++lr77U+X41QGS/5wOSjkDDPu12Nm0OTkuHWyfSjaNpBTioymn2835+uJgLb0mT01/72j/acvNC7Pdu+uZEah1hcc2FG2Tpjl3ko8u9gxmqjHXRYp5bwo0EbTcitNLWuFbibWYe+o/8dCKkDkK8fiGzVQ8q2TTuJa8Qbr6CG9HW/Q+B/uEgiIMwk96o1+j7uO5f+5C/SQsWkHiECAnEcseLgFiOAZ9Z8d8Df94FuSsFOr5gAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAyMC0wNi0yNVQwMDo0NDoxOS0wNDowMIYews8AAAAldEVYdGRhdGU6bW9kaWZ5ADIwMjAtMDYtMjVUMDA6NDQ6MTktMDQ6MDD3Q3pzAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAABJRU5ErkJggg==';

        $latteSpan = Html::el('span', ['title' => 'Dostupné helpery']);
        //$latteImg = Html::el('img', ['src' => $imgBase64, 'title' => 'Latte']);
        $latteName = Html::el('span')
            ->setHtml('<strong>{$}</strong> helpers');

        return $latteSpan
            //->addHtml($latteImg)
            ->addHtml($latteName);
    }

    function getPanel() {
        return Helpers::capture(
            function() {
                $data = [];
                foreach(self::$data as $title => $fncs) {
                    ksort($fncs);
                    if(count($fncs) > 0) {
                        $data[] = [
                            'title' => Strings::firstUpper(sprintf('%s (%d)', $title, count($fncs))),
                            'fncs' => $fncs
                        ];
                    }
                }
                require __DIR__."/panels/latte-helper.panel.phtml";
            }
        );
    }
}

?>
