<?php

namespace IZON\Templating\Latte\Loaders;

use IZON\Utils\Locale;
use Latte\Loaders\FileLoader as LatteFileLoader;
use function IZON\String\startsWith;

class FileLoader extends LatteFileLoader {

    /** @var null|Locale */
    protected $locale;

    public function getReferredName($file, $referringFile): string {
        if(startsWith($file, '//')) {
            $file = substr($file, 2);
            $referringFile = '';
        }

        if( $this->locale !== null ) {
            $localizedFile = preg_replace(
                '#.latte$#',
                '.'. $this->locale->toLocaleTag() .'.latte',
                $file
            );
            if(file_exists($this->baseDir ."/". $localizedFile)) { // does
                return $localizedFile;
            }
        }

        return parent::getReferredName($file, $referringFile); // TODO: Change the autogenerated stub
    }

    /**
     * @param Locale $locale
     */
    public function setLocale(Locale $locale): void {
        $this->locale = $locale;
    }
}
