<?php

namespace IZON\Templating\Latte;

use IZON\Templating\TemplateFactoryInterface;
use IZON\Templating\TemplateInterface;
use IZON\Templating\TemplateSeedInterface;
use Latte\Engine;

class LatteTemplateFactory implements TemplateFactoryInterface {
    /**
     * @var Engine
     */
    protected $engine;

    /**
     * LatteTemplateFactory constructor.
     * @param Engine $engine
     */
    public function __construct(Engine $engine) {
        $this->engine = $engine;
    }

    /**
     * @param string $name
     * @param array $params
     * @return TemplateInterface
     */
    public function create(string $name, array $params = []): TemplateInterface {
        return new LatteTemplate($this->engine, $name, $params);
    }

    /**
     * @param TemplateSeedInterface $seed
     * @return TemplateInterface
     */
    public function grow(TemplateSeedInterface $seed): TemplateInterface {
        return $this->create($seed->getName(), $seed->getParameters());
    }

}
