<?php

namespace IZON\Templating\Latte\Helpers\Tags;

use RuntimeException;

class ViteClientTagSource extends AbstractUnpairedCallableTagSource
{
    /**
     * @var array<string, array{host: string, buildDir: string, dev: bool}>
     */
    protected array $config;

    /**
     * @param array<string, array{host: string, buildDir: string, dev: bool}> $config
     */
    public function __construct(array $config)
    {
        parent::__construct('viteClient');
        $this->config = $config;
    }

    public function getProvider(): callable
    {
        $configs = $this->config;
        return function (string $instance) use ($configs) {
            $config = $configs[$instance] ?? null;
            if ($config === null) {
                throw new RuntimeException("Instance '$instance' not exist in vite config.");
            }
            if (!$config['dev']) {
                return;
            }
            $src = "{$config['host']}/@vite/client";
            echo '<script type="module" src="' . $src . '"></script>' . PHP_EOL;
        };
    }
}
