<?php

namespace IZON\Templating\Latte\Helpers\Tags;

use Latte\CompileException;
use Latte\Compiler\Nodes\Php\Expression\ArrayNode;
use Latte\Compiler\Nodes\StatementNode;
use Latte\Compiler\Position;
use Latte\Compiler\PrintContext;
use Latte\Compiler\Tag;

class UnpairedCallableTag extends StatementNode
{
    protected string $providerName;

    protected ArrayNode $arguments;

    protected Position $line;


    final protected function __construct()
    {
    }

    /**
     * @throws CompileException
     */
    public static function create(Tag $tag, string $providerName): static
    {
        $tag->expectArguments();
        $node = new static();
        $node->arguments = $tag->parser->parseArguments();
        $node->line = $tag->position;
        $node->providerName = $providerName;
        return $node;
    }

    public function print(PrintContext $context): string
    {
        return $context->format(
            "(\$this->global->{$this->providerName})(%args); %line\n",
            $this->arguments,
            $this->line
        );
    }

    public function &getIterator(): \Generator
    {
        // same as in Latte\Essential\Nodes\RawPhpNode
        false && yield; // @phpstan-ignore-line
    }
}
