<?php

namespace IZON\Templating\Latte\Helpers\Tags;

class IncludeStylesTagSource extends AbstractUnpairedCallableTagSource
{
    protected string $rootDir;

    public function __construct(string $rootDir)
    {
        parent::__construct('includeStyles');
        $this->rootDir = $rootDir;
    }

    public function getProvider(): callable
    {
        $rootDir = $this->rootDir;
        return function (array $styles, array $params = []) use ($rootDir) {
            $params = array_merge(['optional' => false], $params);
            foreach ($styles as $style) {
                $filePath = $rootDir . $style;
                $exists = file_exists($filePath);

                if (!$params['optional'] && !$exists) {
                    throw new \RuntimeException("File '$filePath' not exist.");
                }

                if (is_dir($filePath)) {
                    throw new \RuntimeException("File '$filePath' is directory.");
                }

                if (!$exists) {
                    continue;
                }

                $timestamp = filemtime($filePath);
                $href = $style . '?' . $timestamp;
                $mediaAttr = ($params['media'] ?? null) ? ' media="' . $params['media'] . '"' : '';
                echo '<link href="' . $href . '" rel="stylesheet" type="text/css"' . $mediaAttr . '/>' . PHP_EOL;
            }
        };
    }
}
