<?php

namespace IZON\Templating\Latte\Helpers\Tags;

use RuntimeException;

class IncludeScriptsTagSource extends AbstractUnpairedCallableTagSource
{
    protected string $rootDir;

    public function __construct(string $rootDir)
    {
        parent::__construct('includeScripts');
        $this->rootDir = $rootDir;
    }

    public function getProvider(): callable
    {
        $rootDir = $this->rootDir;
        return function (array $scripts, array $params = []) use ($rootDir) {
            $params = array_merge(['optional' => false], $params);
            $attributes = $params['attributes'] ?? [];
            $attributeString = '';
            foreach ($attributes as $key => $value) {
                $attributeString .= ' ' . $key . '="' . $value . '"';
            }
            foreach ($scripts as $script) {
                $filePath = $rootDir . $script;
                $exists = file_exists($filePath);

                if (!$params['optional'] && !$exists) {
                    throw new RuntimeException("File '$filePath' not exist.");
                }

                if (is_dir($filePath)) {
                    throw new RuntimeException("File '$filePath' is directory.");
                }

                if (!$exists) {
                    continue;
                }

                $timestamp = filemtime($filePath);
                echo '<script type="text/javascript" src="' . $script . '?' . $timestamp . '"' . $attributeString . '></script>' . PHP_EOL;
            }
        };
    }
}
