<?php

namespace IZON\Templating\Latte\Helpers\Tags;

use Latte\Compiler\Node;
use Latte\Compiler\Tag;

abstract class AbstractUnpairedCallableTagSource implements TagSourceInterface
{
    protected string $name;

    /**
     * @param string $name
     */
    public function __construct(string $name)
    {
        $this->name = $name;
    }


    public function create(Tag $tag): Node
    {
        return UnpairedCallableTag::create($tag, $this->getProviderName());
    }

    abstract public function getProvider(): ?callable;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    public function getProviderName(): string
    {
        $return = preg_replace("#\:#", "_", $this->getName());
        if ($return === null) {
            throw new \RuntimeException("Cannot convert tag name to provider name = " . $this->getName() . ".");
        }
        return $return;
    }
}
