<?php

namespace IZON\Templating\Latte\Helpers;

use IZON\Templating\Latte\Helpers\Filters\TemplateFilterInterface;
use IZON\Templating\Latte\Helpers\Functions\TemplateFunctionInterface;
use IZON\Templating\Latte\Helpers\Tags\TagSourceInterface;
use Latte\Extension;

class LatteTemplatingExtension extends Extension
{
    /**
     * @var TemplateFunctionInterface[]
     */
    protected array $functions = [];

    /**
     * @var TagSourceInterface[]
     */
    protected array $tagsSources = [];

    /**
     * @var TemplateFilterInterface[]
     */
    protected array $filters = [];

    /**
     * @param TemplateFunctionInterface[] $functions
     * @param TagSourceInterface[] $tagsSources
     * @param TemplateFilterInterface[] $filters
     */
    public function __construct(array $functions = [], array $tagsSources = [], array $filters = [])
    {
        $this->functions = $functions;
        $this->tagsSources = $tagsSources;
        $this->filters = $filters;
    }


    /** @inheritDoc */
    public function getFunctions(): array
    {
        $functions = [];
        foreach ($this->functions as $function) {
            $functions[$function->getName()] = $function->getFunction();
        }
        return $functions;
    }

    public function getTags(): array
    {
        $tags = [];
        foreach ($this->tagsSources as $source) {
            $tags[$source->getName()] = [$source, 'create'];
        }
        return $tags;
    }

    public function getFilters(): array
    {
        $filters = [];
        foreach ($this->filters as $filter) {
            $filters[$filter->getName()] = $filter->getFunction();
        }
        return $filters;
    }

    public function getProviders(): array
    {
        $providers = [];
        foreach ($this->tagsSources as $source) {
            $provider = $source->getProvider();
            if (!is_callable($provider)) {
                continue;
            }
            $providers[$source->getProviderName()] = $provider;
        }
        return $providers;
    }
}
