<?php

namespace IZON\Templating\Latte\Helpers\Functions;

use IZON\MVC\Router\Context\RouteContextProvider;
use IZON\Templating\Latte\Helpers\Abstracts\AbstractTranslate;
use IZON\Translator\Translator;

class TranslateFunction extends AbstractTranslate implements TemplateFunctionInterface
{
    protected RouteContextProvider $routeContextProvider;

    public function __construct(Translator $translator, RouteContextProvider $routeContextProvider)
    {
        parent::__construct($translator);
        $this->routeContextProvider = $routeContextProvider;
    }

    public function getFunction(): callable
    {
        $translator = $this->translator;
        $routeContextProvider = $this->routeContextProvider;
        return function (string $key, array $parameters = [], ?string $defaultText = null, ?string $locale = null) use (
            $translator,
            $routeContextProvider
        ) {
            $context = $routeContextProvider->getContext();
            if ($context) {
                $locale = $context->getParameters()['localeTag'] ?? $locale;
            }
            return $translator->translate($key, $parameters, $defaultText, $locale);
        };
    }
}
