<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Functions;

use RuntimeException;
use function file_exists;
use function filemtime;
use function is_dir;

class TimestampAssetFunction implements TemplateFunctionInterface
{
    protected string $rootDir;

    public function __construct(string $rootDir)
    {
        $this->rootDir = $rootDir;
    }

    public function getName(): string
    {
        return 'timestampAsset';
    }

    public function getFunction(): callable
    {
        return function (string $path) {
            $rootDir = $this->rootDir;

            $filePath = $rootDir . $path;
            if (!file_exists($filePath) || is_dir($filePath)) {
                throw new RuntimeException("Asset file '$filePath' does not exist.");
            }

            $timestamp = filemtime($filePath);
            return $path . '?' . $timestamp;
        };
    }
}
