<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Functions;

use IZON\MVC\Router\Context\RouteContextProvider;
use IZON\MVC\Router\FindURLParameters;
use IZON\MVC\Router\RouterInterface;

class RouteTemplateFunction implements TemplateFunctionInterface
{
    protected RouterInterface $router;

    protected RouteContextProvider $routeContextProvider;

    /**
     * @param RouterInterface $router
     * @param RouteContextProvider $routeContextProvider
     */
    public function __construct(RouterInterface $router, RouteContextProvider $routeContextProvider)
    {
        $this->router = $router;
        $this->routeContextProvider = $routeContextProvider;
    }


    public function getName(): string
    {
        return 'route';
    }

    public function getFunction(): callable
    {
        $router = $this->router;
        $routeContextProvider = $this->routeContextProvider;
        return function (string $routeName, array $parameters = []) use ($router, $routeContextProvider) {
            $context = $routeContextProvider->getContext();
            if ($context) {
                $parameters = $context->extendParameters($parameters);
            }
            $findRouteParams = new FindURLParameters($routeName, $parameters);
            return $router->findURL($findRouteParams);
        };
    }
}
