<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Functions;

class GettextTemplateFunction implements TemplateFunctionInterface
{
    public function getName(): string
    {
        return "gettext";
    }

    public function getFunction(): callable
    {
        return function ($string, ...$args) {
            if (!empty($args)) {
                array_unshift($args, _($string));
                echo call_user_func_array('sprintf', $args);
            } else {
                echo _($string);
            }
        };
    }
}
