<?php

namespace IZON\Templating\Latte\Helpers\Abstracts;

use IZON\Translator\Translator;

abstract class AbstractTranslate
{
    protected Translator $translator;

    /**
     * @param Translator $translator
     */
    public function __construct(Translator $translator)
    {
        $this->translator = $translator;
    }


    public function getName(): string
    {
        return 'translate';
    }

    public function getFunction(): callable
    {
        $translator = $this->translator;
        return function (string $key, array $parameters = [], ?string $locale = null) use ($translator) {
            return $translator->translate($key, $parameters, $locale);
        };
    }
}
