<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Macros;


use IZON\Templating\Latte\Helpers\Abstracts\AbstractMacro;
use Tracy\Helpers;


class HrefLoad extends AbstractMacro {

    public function getMacro(): string {
        return '\IZON\Templating\Latte\Helpers\Macros\HrefLoad::run([%s])';
    }

    public function getTag(): string {
        return '\' href="\'. \IZON\Templating\Latte\Helpers\Macros\HrefLoad::run([%s]) .\'"\'';
    }

    public static function run($args) {
        // @ avoid notice from undefined index
        @list($context, $controllerId, $parameters, $methodName, $locale, $domainUID, $forceDomain) = $args;

        $parameters = $parameters ? $parameters : [];
        $methodName = $methodName ? $methodName : null;
        $locale = $locale ? $locale : null;
        $domainUID = $domainUID ? $domainUID : null;
        $forceDomain = $forceDomain ? $forceDomain : false;

        if($context instanceof \IZON\MVC\Context\ContextInterface) {
            if(is_null($locale)) {
                $locale = $context->getLocale();
            }
        }
        if(is_string($locale)) {
            $locale = \IZON\Utils\Locale::forLocaleTag($locale);
        }

        return $context->getControllerURL($controllerId, $parameters, $methodName, $locale, $domainUID, $forceDomain);
    }

    public function getTracyDescription(): string {
        $example1 = Helpers::escapeHtml('<a n:href="x y"></a>');

        return '<strong>{href x y}</strong> přes makro<br><strong>'
            .$example1
            .'</strong> přes n:tag';
    }
}
