<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Functions;

use RuntimeException;
use IZON\MVC\Config;
use IZON\Templating\Latte\Helpers\Abstracts\AbstractFunction;
use Psr\Container\ContainerInterface;
use function filemtime;
use function file_exists;
use function is_dir;

class TimestampAssetLoad extends AbstractFunction {

    public function getCallback(ContainerInterface $container): callable {
        return function(string $path) use ($container) {
            $rootDir = $container->get(Config::APP_DIR_IDENTIFIER).'/www';

            $filePath = $rootDir.$path;
            if(!file_exists($filePath) || is_dir($filePath)) {
                throw new RuntimeException("File '$filePath' not exist.");
            }

            $timestamp = filemtime($filePath);
            echo $path.'?'.$timestamp;
        };
    }
}
