<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Filters;

use IZON\DBLocale\Domain\DBCurrency;
use IZON\Templating\Latte\Helpers\Abstracts\AbstractFilter;
use Nette\Utils\Html;
use Psr\Container\ContainerInterface;

class PriceStringLoad extends AbstractFilter {

    public function getCallback(ContainerInterface $container): callable {
        return function(float $value, DBCurrency $currency, bool $stringOnZero = false, ?string $textOnZero = null) use ($container):Html {
            $priceValCompare = number_format($value, $currency->getRounding(), '.', '&nbsp;');

            if($stringOnZero && $priceValCompare == 0) {
                return Html::el('span')->setText($textOnZero === null ? _('Zdarma') : $textOnZero);
            }

            $priceVal = number_format($value, $currency->getRounding(), ',', '&nbsp;');
            $priceVal = $priceVal.'&nbsp;'.$currency->getHtmlString();

            $priceString = new Html();
            $priceString->setHtml($priceVal);
            return $priceString;
        };
    }

    public function getTracyDescription(): string {
        return '<strong>{$priceFloat|priceString:$currency}<strong> => 2 357 Kč';
    }
}
