<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Functions;


use IZON\Templating\Latte\Helpers\Abstracts\AbstractFunction;
use Psr\Container\ContainerInterface;

class ThumbnailLoad extends AbstractFunction {

    public function getCallback(ContainerInterface $container): callable {
        return function($image, array $parameters = []) use ($container) {
            /** @var \IZON\Thumber\Services\ThumbnailService $service */
            $service = $container->get('thumber.service');
            $thumbnailer = $service->getThumbnailer();

            return $thumbnailer->getThumbnailURL($image, $parameters);
        };
    }
}
