<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Functions;

use RuntimeException;
use IZON\MVC\Config;
use IZON\Templating\Latte\Helpers\Abstracts\AbstractFunction;
use Psr\Container\ContainerInterface;

class IncludeStylesLoad extends AbstractFunction {

    public function getCallback(ContainerInterface $container): callable {
        return function(array $styles, string $type = "css", array $params = []) use ($container) {
            $rootDir = $container->get(Config::APP_DIR_IDENTIFIER).'/www';
            $params = array_merge(['optional' => false], $params);
            foreach($styles as $style) {
                $filePath = $rootDir.$style;
                $exists = file_exists($filePath);

                if(!$params['optional'] && !$exists) {
                    throw new RuntimeException("File '$filePath' not exist.");
                }

                if(is_dir($filePath)) {
                    throw new RuntimeException("File '$filePath' is directory.");
                }
                
                if(!$exists) {
                    continue;
                }
                
                $timestamp = filemtime($filePath);
                echo '<link href="'
                    .$style
                    .'?'
                    .$timestamp
                    .'" rel="stylesheet" type="text/css" '
                    .(($params['media'] ?? '')
                    != '' ? ' media="'.$params['media'].'"' : '')
                    .' />'
                    .PHP_EOL;
            }
        };
    }
}
