<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Filters;


use IZON\AppLibs\Prices\Presentation\PriceHelper;
use IZON\DBLocale\Domain\DBCurrency;
use IZON\Templating\Latte\Helpers\Abstracts\AbstractFilter;
use Nette\Utils\Html;
use Psr\Container\ContainerInterface;

class PriceStringLoad extends AbstractFilter {

    public function getCallback(ContainerInterface $container): callable {
        return function(float $value, DBCurrency $currency, $stringOnZero = false) use ($container):Html {
            $priceVal = number_format($value, $currency->getRounding(), ',', '&nbsp;');
            if($stringOnZero && $priceVal == 0) {
                return Html::el('span')->setText(_('Zdarma'));
            }
            $priceVal = $priceVal.'&nbsp;'.$currency->getHtmlString();

            $priceString = new Html();
            $priceString->setHtml($priceVal);
            return $priceString;
        };
    }

    public function getTracyDescription(): string {
        return '<strong>{$priceFloat|priceString:$currency}<strong> => 2 357 Kč';
    }
}
