<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Functions;


use IZON\Templating\Latte\Helpers\Abstracts\AbstractFunction;
use Psr\Container\ContainerInterface;

class GettextLoad extends AbstractFunction {

    public function getCallback(ContainerInterface $container): callable {
        return function($string, ...$args) use ($container) {
            if(!empty($args)) {
                array_unshift($args, _($string));
                echo call_user_func_array('sprintf', $args);
            } else {
                echo _($string);
            }
        };
    }

    public function getName(): string {
        return "gettext";
    }
}
