<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Macros;


use IZON\Forms\Fields\BaseField;
use IZON\Forms\Form;
use IZON\Forms\FormFieldTemplate;
use IZON\Templating\Latte\Helpers\Abstracts\AbstractMacro;

class FieldLoad extends AbstractMacro {

    public function getMacro(): string {
        return '\IZON\Templating\Latte\Helpers\Macros\FieldLoad::run([%s])';
    }

    public function getTag(): string {
        // TODO: Implement getTag() method.
    }

    public static function run($args) {
        @list($formOrField, $fieldNameOrParams, $params) = $args;

        $field = null;
        if( $formOrField instanceof BaseField ) {
            $field = $formOrField;
            if( is_array($fieldNameOrParams) ) {
                $params = $fieldNameOrParams;
            }
        } else if( $formOrField instanceof Form ) {
            $field = $formOrField->getField($fieldNameOrParams);
        } else {
            throw new \Exception('First parameters of field macro must be Form or FormField.');
        }

        if(empty($params)) {
            $params = [];
        }
        $typeTemplatesDir = __BASE_DIR__.'/app/web/form-flelds-templates';
        if(!array_key_exists('template', $params) || empty($params['template'])) {
            $params['template'] = 'default';
        }
        return FormFieldTemplate::getFiled(
            $params['template'],
            $typeTemplatesDir,
            $field,
            $params
        );

    }
}
