<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Functions;

use RuntimeException;
use IZON\MVC\Config;
use IZON\Templating\Latte\Helpers\Abstracts\AbstractFunction;
use Psr\Container\ContainerInterface;

class IncludeStylesLoad extends AbstractFunction {

    public function getCallback(ContainerInterface $container): callable {
        return function(array $styles, $type = "css", $params = []) use ($container) {
            $rootDir = $container->get(Config::APP_DIR_IDENTIFIER).'/www';

            foreach($styles as $style) {
                $filePath = $rootDir.$style;
                if(!file_exists($filePath) || is_dir($filePath)) {
                    throw new RuntimeException("File '$filePath' not exist.");
                }

                $timestamp = filemtime($filePath);
                echo '<link href="'
                    .$style
                    .'?'
                    .$timestamp
                    .'" rel="stylesheet" type="text/css" '
                    .(($params['media'] ?? '')
                    != '' ? ' media="'.$params['media'].'"' : '')
                    .' />'
                    .PHP_EOL;
            }
        };
    }
}
