<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Functions;

use RuntimeException;
use IZON\MVC\Config;
use IZON\Templating\Latte\Helpers\Abstracts\AbstractFunction;
use Psr\Container\ContainerInterface;

class IncludeScriptsLoad extends AbstractFunction {

    public function getCallback(ContainerInterface $container): callable {
        return function(array $scripts) use ($container) {
            $rootDir = $container->get(Config::APP_DIR_IDENTIFIER).'/www';

            foreach($scripts as $script) {
                $filePath = $rootDir.$script;
                if(!file_exists($filePath) || is_dir($filePath)) {
                    throw new RuntimeException("File '$filePath' not exist.");
                }

                $timestamp = filemtime($filePath);
                echo '<script type="text/javascript" src="'.$script.'?'.$timestamp.'"></script>'.PHP_EOL;
            }
        };
    }

    public function getTracyDescription(): string {
        return 'Vloží scripty s timestampem do stránky';
    }
}
