<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Abstracts;

use Nette\Utils\Strings;
use ReflectionClass;
use Psr\Container\ContainerInterface;

abstract class AbstractFunction {

    public function getName(): string {
        $reflection = new ReflectionClass(get_called_class());
        return Strings::firstLower(Strings::substring($reflection->getShortName(), 0, -4));
    }

    public abstract function getCallback(ContainerInterface $container): callable;

    public function getTracyDescription(): string {
        return '';
    }

    public function getTracyTitle(): string {
        return $this->getName();
    }
}
